local Engine     = GetSelf()
local dev = Engine
dofile(LockOn_Options.common_script_path.."devices_defs.lua")
dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")

function debug_print(x)

end

local update_rate = 0.05
make_default_activity(update_rate)

local sensor_data = get_base_data()

local iCommandEnginesStart  = 309
local iCommandEnginesStop   = 310
local iCommandPlaneFuelOff  = 80
local iCommandPlaneFuelOn   = 79
local iCommandPlaneThrustCommon = 2004

local rpm_main = get_param_handle("RPM")
local rpm_deci = get_param_handle("RPM_DECI")

function update_rpm()
    local rpm=sensor_data.getEngineLeftRPM()

    if rpm < 55 then
        rpm_main:set(rpm/1.03)
    else
        rpm = rpm - 55
        rpm = (rpm * 1.0667) + 55
        rpm_main:set(rpm)
    end

    rpm=rpm/10.0
    rpm=rpm-math.floor(rpm)
    rpm_deci:set(rpm)
end

local prev_rpm=0
local prev_throttle_pos=0
local once_per_sec = 1/update_rate
function update()
	local rpm = sensor_data.getEngineLeftRPM()
    local throttle = sensor_data.getThrottleLeftPosition()
    local gear = get_aircraft_draw_argument_value(0) -- nose gear
  
    update_rpm()

    once_per_sec = once_per_sec - 1
    if once_per_sec <= 0 then
        accumulate_temp()

        once_per_sec = 1/update_rate
    end

    if throttle_state == THROTTLE_OFF then
        throttle = -1
    elseif throttle_state == THROTTLE_IGN then
        throttle = -0.2
    end

    local throttle_pos = throttle_position_wma:get_WMA(throttle)
    if prev_throttle_pos ~= throttle_pos then
        if throttle <= 0.01 then
        end
        prev_throttle_pos = throttle_pos
    end
    throttle_position:set(throttle_pos)
end

need_to_be_closed = false
